/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef __mx__wait_queue_h__
#define __mx__wait_queue_h__

#include "mx__lib_types.h"

#define MX__WAIT_QUEUE_FROM_QUEUE_ELT(x)		\
 ((struct mx__wait_queue *)				\
  (((char*) x)						\
   - offsetof(struct mx__wait_queue, queue_elt)))

static inline void
mx__wait_queue_init(struct mx__wait_queue_head * head)
{
  head->prev = head->next = head;
}

#define mx__wait_queue_isempty(head) (head == (head)->next)

static inline void
mx__wait_queue_spliceout(struct mx__wait_queue_head * head, struct mx__wait_queue * wq)
{
  wq->queue_elt.next->prev = wq->queue_elt.prev;
  wq->queue_elt.prev->next = wq->queue_elt.next;
}

static inline struct mx__wait_queue *
mx__wait_queue_dequeue (struct mx__wait_queue_head * head)
{
  if (head == head->next)
    return NULL;
  else {
    struct mx__wait_queue * wq = MX__WAIT_QUEUE_FROM_QUEUE_ELT(head->next);
    head->next = head->next->next;
    head->next->prev = head;
    return wq;
  }
}

static inline void
mx__wait_queue_enqueue(struct mx__wait_queue_head * head, struct mx__wait_queue * wq)
{
  wq->queue_elt.next = head;
  wq->queue_elt.prev = head->prev;
  head->prev->next = &wq->queue_elt;
  head->prev = &wq->queue_elt;
}

static inline int
mx__wait_queue_length (struct mx__wait_queue_head * head)
{
  struct mx__wait_queue_head * elt;
  int length = 0;
  for (elt = head->next; elt != head; elt = elt->next)
    length++;
  return length;
}

#define MX__FOREACH_WAIT_QUEUE(wq, elt, head)				\
for(elt = (head)->next, wq = MX__WAIT_QUEUE_FROM_QUEUE_ELT(elt);	\
    elt != head;							\
    elt = elt->next, wq = MX__WAIT_QUEUE_FROM_QUEUE_ELT(elt))

#endif
